{********************************************
; File: Dialogs.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT DIALOGS;

INTERFACE

USES TYPES,QUICKDRAW,EVENTS,CONTROLS,WINDOWS,LINEEDIT;

CONST
{ Error Codes }
badItemType = $150A;
newItemFailed = $150B;
itemNotFound = $150C;
notModalDialog = $150D;

{ Command Codes }
getInitView = $0001;
getInitTotal = $0002;
getInitValue = $0003;
scrollLineUp = $0004;
scrollLineDown = $0005;
scrollPageUp = $0006;
scrollPageDown = $0007;
scrollThumb = $0008;

{ Item Type Codes }
buttonItem = $000A;
checkItem = $000B;
radioItem = $000C;
scrollBarItem = $000D;
userCtlItem = $000E;
statText = $000F;
longStatText = $0010;
editLine = $0011;
iconItem = $0012;
picItem = $0013;
userItem = $0014;
userCtlItem2 = $0015;
longStatText2 = $0016;
itemDisable = $8000;

{ Item Type Ranges }
minItemType = $000A;
maxItemType = $0016;

{ ItemID Codes }
ok = $0001;
cancel = $0002;

{ Part Codes }
inButton = $0002;
inCheckBox = $0003;
inRadioButton = $0004;
inUpArrow = $0005;
inDownArrow = $0006;
inPageUp = $0007;
inPageDown = $0008;
inStatText = $0009;
inGrow = $000A;
inEditLine = $000B;
inUserItem = $000C;
inLongStatText = $000D;
inIconItem = $000E;
inLongStatText2 = $000F;
inThumb = $0081;

{ Stage Bit Vectors }
okDefault = $0000;
cancelDefault = $0040;
alertDrawn = $0080;

{ Other Constants }
{$IFC UNDEFINED atItemListLength }  { AlertTemplate - Default number of Item Templates }
atItemListLength = $0005;
{$SETC atItemListLength := 0}
{$ENDC}
{$IFC UNDEFINED dtItemListLength }  { DialogTemplate - Default number of Item Templates }
dtItemListLength = $0008;
{$SETC dtItemListLength := 0}
{$ENDC}

TYPE

DialogPtr = GrafPortPtr ;

ItemTempHndl = ^ItemTempPtr;
ItemTempPtr = ^ItemTemplate;
ItemTemplate = RECORD
    itemID : Integer;
    itemRect : Rect;
    itemType : Integer;
    itemDescr : Ptr;
    itemValue : Integer;
    itemFlag : Integer;
    itemColor : Ptr; { pointer to appropriate type of color table }
END;

AlertTempHndl = ^AlertTempPtr;
AlertTempPtr = ^AlertTemplate;
AlertTemplate = PACKED RECORD
    atBoundsRect : Rect;
    atAlertID : Integer;
    atStage1 : Byte;
    atStage2 : Byte;
    atStage3 : Byte;
    atStage4 : Byte;
    atItemList : ARRAY[1..atItemListLength] OF ItemTempPtr; { Null terminated array }
END;

DlgTempHndl = ^DlgTempPtr;
DlgTempPtr = ^DialogTemplate;
DialogTemplate = RECORD
    dtBoundsRect : Rect;
    dtVisible : Boolean;
    dtRefCon : Longint;
    dtItemList : ARRAY[1..dtItemListLength] OF ItemTempPtr; { Null terminated array }
END;

UserCtlItemPBHndl = ^UserCtlItemPBPtr;
UserCtlItemPBPtr = ^UserCtlItemPB;
UserCtlItemPB = RECORD
    defProcParm : LongProcPtr;
    titleParm : Ptr;
    param2 : Integer;
    param1 : Integer;
END;

FUNCTION Alert ( alertTemplatePtr:AlertTemplate; filterProcPtr:WordProcPtr) : Integer ;
FUNCTION CautionAlert ( alertTemplatePtr:AlertTemplate; filterProcPtr:WordProcPtr) : Integer ;
PROCEDURE CloseDialog ( theDialogPtr:DialogPtr)  ;
FUNCTION DefaultFilter ( theDialogPtr:DialogPtr; theEventPtr:EventRecord;VAR itemHitPtr:Integer) : Boolean ;
PROCEDURE DialogBootInit   ;
PROCEDURE DialogReset   ;
FUNCTION DialogSelect ( theEventPtr:EventRecord;VAR resultPtr:WindowPtr;VAR itemHitPtr:Integer) : Boolean ;
PROCEDURE DialogShutDown   ;
PROCEDURE DialogStartUp ( userID:Integer)  ;
FUNCTION DialogStatus  : Boolean ;
FUNCTION DialogVersion  : Integer ;
PROCEDURE DisableDItem ( theDialogPtr:DialogPtr; itemID:Integer)  ;
PROCEDURE DlgCopy ( theDialogPtr:DialogPtr)  ;
PROCEDURE DlgCut ( theDialogPtr:DialogPtr)  ;
PROCEDURE DlgDelete ( theDialogPtr:DialogPtr)  ;
PROCEDURE DlgPaste ( theDialogPtr:DialogPtr)  ;
PROCEDURE DrawDialog ( theDialogPtr:DialogPtr)  ;
PROCEDURE EnableDItem ( theDialogPtr:DialogPtr; itemID:Integer)  ;
PROCEDURE ErrorSound ( soundProcPtr:VoidProcPtr)  ;
FUNCTION FindDItem ( theDialogPtr:DialogPtr; thePoint:Point) : Integer ;
FUNCTION GetAlertStage  : Integer ;
FUNCTION GetControlDItem ( theDialogPtr:DialogPtr; itemID:Integer) : CtlRecHndl ;
FUNCTION GetDefButton ( theDialogPtr:DialogPtr) : Integer ;
PROCEDURE GetDItemBox ( theDialogPtr:DialogPtr; itemID:Integer; itemBoxPtr:Rect)  ;
FUNCTION GetDItemType ( theDialogPtr:DialogPtr; itemID:Integer) : Integer ;
FUNCTION GetDItemValue ( theDialogPtr:DialogPtr; itemID:Integer) : Integer ;
FUNCTION GetFirstDItem ( theDialogPtr:DialogPtr) : Integer ;
PROCEDURE GetIText ( theDialogPtr:DialogPtr; itemID:Integer;VAR text:Str255)  ;
PROCEDURE GetNewDItem ( theDialogPtr:DialogPtr; itemTemplatePtr:ItemTemplate)  ;
FUNCTION GetNewModalDialog ( dialogTemplatePtr:DialogTemplate) : DialogPtr ;
FUNCTION GetNextDItem ( theDialogPtr:DialogPtr; itemID:Integer) : Integer ;
PROCEDURE HideDItem ( theDialogPtr:DialogPtr; itemID:Integer)  ;
FUNCTION IsDialogEvent ( theEventPtr:EventRecord) : Boolean ;
FUNCTION ModalDialog ( filterProcPtr:WordProcPtr) : Integer ;
FUNCTION ModalDialog2 ( filterProcPtr:WordProcPtr) : Longint ;
PROCEDURE NewDItem ( theDialogPtr:DialogPtr; itemID:Integer; itemRectPtr:Rect; itemType:Integer; itemDescr:Ptr; itemValue:Integer; itemFlag:Integer; itemColorPtr:Ptr)  ;
FUNCTION NewModalDialog ( dBoundsRectPtr:Rect; dVisibleFlag:Boolean; dRefCon:Longint) : DialogPtr ;
FUNCTION NewModelessDialog ( dBoundsRectPtr:Rect; dTitle:Str255; dBehindPtr:DialogPtr; dFlag:Integer; dRefCon:Longint; dFullSizePtr:Rect) : DialogPtr ;
FUNCTION NoteAlert ( alertTemplatePtr:AlertTemplate; filterProcPtr:WordProcPtr) : Integer ;
PROCEDURE ParamText ( param0:Str255; param1:Str255; param2:Str255; param3:Str255)  ;
PROCEDURE RemoveDItem ( theDialogPtr:DialogPtr; itemID:Integer)  ;
PROCEDURE ResetAlertStage   ;
PROCEDURE SelectIText ( theDialogPtr:DialogPtr; itemID:Integer; startSel:Integer; endSel:Integer)  ;
PROCEDURE SelIText ( theDialogPtr:DialogPtr; itemID:Integer; theStringPtr:StringPtr)  ;
PROCEDURE SetDAFont ( fontHandle:FontHndl)  ;
PROCEDURE SetDefButton ( defButtonID:Integer; theDialogPtr:DialogPtr)  ;
PROCEDURE SetDItemBox ( theDialogPtr:DialogPtr; itemID:Integer; itemBoxPtr:Rect)  ;
PROCEDURE SetDItemType ( itemType:Integer; theDialogPtr:DialogPtr; itemID:Integer)  ;
PROCEDURE SetDItemValue ( itemValue:Integer; theDialogPtr:DialogPtr; itemID:Integer)  ;
PROCEDURE SetIText ( theDialogPtr:DialogPtr; itemID:Integer; theString:Str255)  ;
PROCEDURE ShowDItem ( theDialogPtr:DialogPtr; itemID:Integer)  ;
FUNCTION StopAlert ( alertTemplatePtr:AlertTemplate; filterProcPtr:WordProcPtr) : Integer ;
PROCEDURE UpdateDialog ( theDialogPtr:DialogPtr; updateRgnHandle:RegionHndl)  ;

IMPLEMENTATION

END.
